%-------------------------------------------------------
% This is the document class of the ENPESJ LaTeX template
% Version 1.0 (12.2020)
% Contributors: 
% Dr. of Eng. O. Kherif
% Prof. A. Mekhaldi
% 
%-------------------------------------------------------

%-------------------------------------------------------
% For any possible help, 
% please contact Dr. Kherif at (omar.kherif@g.enp.edu.dz) 
% or send your feedback to the ENPESJ staff
% Contact details can be found on the journal website
% (https://enpesj.enp.edu.dz/index.php/enpesj/)
%-------------------------------------------------------
 



%//////////////START ENPESJ DOCUMENTCLASS\\\\\\\\\\\\\\\\

\ProvidesClass{ENPESJclass}[2020/12/15 V1 by Omar Kherif]
\typeout{-- https://enpesj.enp.edu.dz/index.php/enpesj/}
\NeedsTeXFormat{LaTeX2e}
\newcommand{\headlinecolor}{\normalcolor}
\RequirePackage{xcolor}
\definecolor{slcolor}{HTML}{882B21}
\DeclareOption{onecolumn}{\OptionNotUsed}
\DeclareOption{green}{\renewcommand{\headlinecolor}{\color{green}}}
\DeclareOption{red}{\renewcommand{\headlinecolor}{\color{slcolor}}}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}
\ProcessOptions\relax
\LoadClass[twocolumn, twoside, 11pt]{article}

%----------------------------------------------------------
% Some required packages
%----------------------------------------------------------
\usepackage[utf8]{inputenc}
\usepackage[T1]{fontenc}

\usepackage{geometry} 
\usepackage{setspace}                  
\usepackage{xcolor}
\usepackage{mdframed}


\usepackage{microtype} % Improves character and word spacing
\usepackage{fancyvrb} % Allows customization of verbatim environments
\fvset{fontsize=\normalsize} % The font size of all verbatim text can be changed here
\usepackage{xspace} % Used for printing a trailing space better than using a tilde (~) using the \xspace command


% Use Times Roman font,  default to Times.
\renewcommand{\rmdefault}{ptm}
\def\@stringptm{ptm} % Times Roman family
\ifx\f@family\@stringptm\kern 0em\vbox{\hrule\@width 0.5em\@height 0.5pt\kern -0.3ex}\else
\gdef\@SAVESTATEfontfamily{ptm}

%%
%% Other packages have been included near the commands below
%%
%----------------------------------------------------------
% Define the ENPESJ paper geometry
%----------------------------------------------------------
\setlength{\parindent}{0pt}
\setlength{\parskip}{2.0ex plus0.5ex minus0.2ex}

\usepackage{vmargin}
%----------------------------------------------------------
%	MARGINS
%----------------------------------------------------------
\setmarginsrb           {1.50cm}  % left margin 1.0in
                        {0.75cm}  % top margin 0.6in
                        {1.50cm}  % right margin 1.0in
                        {0.50cm}  % bottom margin 0.6in
                        {0.50cm}  % head height 2cm
                        {0.75cm}  % head sep  
                        {0.50cm}   % foot height
                        {0.75cm}  % foot sep            
%----------------------------------------------------------
% Other geometry for twocols
%----------------------------------------------------------
\usepackage{titlesec}
\setlength{\textwidth}{18cm}
\setlength{\textheight}{26.2cm}
%\setcounter{secnumdepth}{0}
\renewcommand{\normalsize}{\fontsize{10}{12}\selectfont}


%----------------------------------------------------------
% Abstract and title
%----------------------------------------------------------
\newenvironment{ENPESJabstract}[1]{%
\twocolumn[
{
	\centering 
	{
	\Huge 
	       \@title
	}\\\medskip\medskip\medskip
	{
	\fontsize{11}{12}  
	\@author
	}\\\medskip\medskip\medskip
}
{ 
	{

        \fontsize{10}{11}  \textbf{Abstract}---\textbf{\ignorespaces#1}
	}
    \medskip\medskip\medskip
}
]
}{}

%----------------------------------------------------------
% Keywords command
%----------------------------------------------------------
\providecommand{\ENPESJkeywords}[1]
{ \newline \newline
\textit{Keywords---}\ignorespaces#1
\medskip\medskip\medskip
}

%----------------------------------------------------------
% Link within the text
%----------------------------------------------------------
\usepackage{hyperref}
\hypersetup{colorlinks=true, urlcolor=red, linkcolor=blue, citecolor=blue}


%----------------------------------------------------------
% Section and subsection definition
%----------------------------------------------------------
\titlespacing*{\section}{0pt}{0pt}{0pt}
\titlespacing*{\subsection}{0pt}{0pt}{0pt}
\titlespacing*{\subsubsection}{0pt}{0pt}{0pt}
\titleformat{\section}{\centering\normalfont\scshape}{\thesection}{5pt}{}
\renewcommand\thesection{\Roman{section}.}


\titleformat{\subsection}{\normalfont\itshape}{\thesubsection}{5pt}{}
\renewcommand\thesubsection{\Alph{subsection}.}

\titleformat{\subsubsection}[runin]{\bf\normalfont\itshape}{\thesubsubsection}{2pt}{}[:\hspace{3pt} ]
\renewcommand\thesubsubsection{\arabic{subsubsection}---}



%----------------------------------------------------------
% Big letter in Introduction
%----------------------------------------------------------
\usepackage{lettrine}
\newenvironment{ENPESJstart}[2][]{%
  \lettrine[lraise=0.1, nindent=0em, slope=-.5em]{#2}{}%
}{}

%----------------------------------------------------------
% Header and footer
%----------------------------------------------------------


\usepackage{fancyhdr}
\pagestyle{fancy}
\renewcommand{\headrulewidth}{0pt}
\fancyhf{}

\providecommand{\ENPESJleftheader}[1]
{
\lhead[{\small\thepage}]{\small \ignorespaces#1}
}

\providecommand{\ENPESJrightheader}[1]
{
\rhead[{\small \ignorespaces#1}]{\small\thepage}
}

\pagestyle{fancyplain}


%\fancyhf{}
% Add copyright to the first page


\AtBeginDocument{%
  \cfoot{\small 2716-912X \copyright \ 2021 Ecole Nationale Polytechnique}%
  \AtBeginShipoutNext{%
    \cfoot{}%
  }%
}
\lfoot{}
\rfoot{}
\pagestyle{fancyplain}

%----------------------------------------------------------
% Author affiliation
%----------------------------------------------------------
\usepackage[perpage]{footmisc}
\usepackage{etoolbox}
\renewcommand\footnoterule{}
\newcommand\ENPESJaffiliation[1]{%
  \let\thefootnote\relax  %
  \footnotetext{\setstretch{0.8}\small #1}%
  \let\thefootnote
}

\newcommand\ENPESJpaperHistory[1]{%
  \let\thefootnote\relax  %
  \footnotetext{\setstretch{0.8}\small #1}%
  \let\thefootnote
}

%----------------------------------------------------------
% Bibliograpy section here
%----------------------------------------------------------
\def\thebibliography#1{\section*{\refname}%
    \footnotesize \ignorespaces
    \list{\@biblabel{\@arabic\c@enumiv}}%
    {\settowidth\labelwidth{\@biblabel{#1}}% 
    \leftmargin\labelwidth
    \advance\leftmargin\labelsep\relax
    \usecounter{enumiv}%
    \let\p@enumiv\@empty
}
}

%----------------------------------------------------------
% Biography section is here
%----------------------------------------------------------
\usepackage{wrapfig}
\usepackage{graphicx}

\newcounter{ENPESJbiography}
\setcounter{ENPESJbiography}{0}
\newenvironment{ENPESJbiography}[2]{%
\begin{wrapfigure}{l}{2.5cm} 
#1
\end{wrapfigure}
\textbf{#2} \small
}{}

\newcounter{ENPESJbiographyNOphoto}
\setcounter{ENPESJbiographyNOphoto}{0}
\newenvironment{ENPESJbiographyNOphoto}[1]{%
\hfill\\  \textbf{#1} \small
}{}



%----------------------------------------------------------
%
%----------------------------------------------------------
%%%%%%%%%%%%%%%%%%%%%%%
% bib des figures flot
\usepackage{graphicx}
\usepackage{epstopdf}


\usepackage{pgfplots}

\usepackage{wrapfig}
\usepackage{subfig}

\usepackage{tikz}
\usetikzlibrary{calc,shadows}
\usetikzlibrary{shadings}
\usetikzlibrary{patterns}
\usepackage{circuitikz} 
\usetikzlibrary{arrows}
\usepackage{marvosym}

\usetikzlibrary{decorations.pathreplacing}
\usepackage{tikzpagenodes}
\usetikzlibrary{decorations.text}
\usepackage{schemabloc}
\usepackage{epstopdf}



%----------------------------------------------------------
\usepackage{amsmath,amsfonts,amssymb,amscd,amsthm,xspace}
\usepackage{etoolbox}
\renewcommand{\tablename}{\small \bf Table.}
\captionsetup[table]{justification=centerlast,
                     labelsep=newline,
                     font=sc,
                     textfont=small}

\renewcommand{\thetable}{\Roman{table}}


\renewcommand{\figurename}{\bf Fig.}

\captionsetup[figure]{
  font=small,
  %justification=raggedright,
  singlelinecheck=false
}

\usepackage{subfig}
\renewcommand{\thesubfigure}{\color{blue}(\alph{subfigure})\color{black}}
\captionsetup[subfloat]{
	font=small,  
	labelformat=simple, 
	labelsep=space
}

%----------------------------------------------------------
%
%----------------------------------------------------------
\usepackage{varioref}
\labelformat{equation}{\color{red}#1\color{black}}
\labelformat{figure}{\color{blue}#1\color{black}}
\labelformat{table}{\color{blue}#1\color{black}}



%----------------------------------------------------------
%
%----------------------------------------------------------
\usepackage{rotating}
\usepackage{graphicx}
\usepackage{cite}
\usepackage{booktabs}